"<place directory here>" 
use "`location'\UnbalancedHH.dta" , clear 


*tostring xwaveid , g(waveid)
gen str7 z = string(xwaveid,"%07.0f")
rename xwaveid waveid 
rename z xwaveid 


*Weights
g hwt_noadj =  hhwth
g hwt_adj = hhwthm 

g hwt_new = hwt_noadj
replace hwt_new = hwt_adj if hwt_noadj == 0

*******************************
*TIME SINCE PURCHASE AND REFINANCE
*******************************

g yearsataddress = hsyrcad
replace yearsataddress = . if yearsataddress<0
replace yearsataddress = round(yearsataddress,1)

g yearmoved = mhyr

*Purchase
g purchyear = hsyr 
g purchprice = hsprice
g purchdebt = hsloana

replace purchyear = . if purchyear < 0
replace purchprice = . if purchprice < 0
replace purchdebt = 0 if purchdebt < 0

foreach i in purchyear purchprice purchdebt {
foreach j in 2002 2006 2010 2014 2018 {
g `i'`j' = `i' if year == `j'
bysort xwaveid: egen `i'`j'max = max(`i'`j') 
}
}


*There are some inconsistencies here but seems ok:
g purchyear_report = .
g purchprice_report = .
g purchdebt_report = .

foreach i in purchyear purchprice purchdebt {
foreach j in 2002 2006 2010 2014 2018 {
replace `i'_report = `i'`j'max if year >= purchyear`j'max
}
}

foreach i in purchyear purchprice purchdebt {
foreach j in 2002 2006 2010 2014 2018 {
drop `i'`j'max `i'`j'
}
}


g nodebt = (purchdebt == 0)
tab nodebt
g nodebt2 = (purchdebt_report == 0)
tab nodebt2
drop nodebt*

g purchduration =year-purchyear_report



*Refinancings

*Ever refinanced?
g refinance = (hsevref==1)
replace refinance = . if hsevref == .

*Total value AFTER refinancing
g refdebt = hsrefvl
replace refdebt = . if refdebt < 0

g refyear = hsrefy
replace refyear = . if refyear < 0


foreach i in refyear refdebt {
foreach j in 2006 2010 2014 2018 {
g `i'`j' = `i' if year == `j'
bysort xwaveid: egen `i'`j'max = max(`i'`j') 
}
}

g refyear_report = .
g refdebt_report = .
foreach i in refyear refdebt {
foreach j in 2006 2010 2014 2018 {
replace `i'_report = `i'`j'max if year >= refyear`j'max
}
}

foreach i in refyear refdebt {
foreach j in 2006 2010 2014 2018 {
drop `i'`j'max `i'`j'
}
}


g refduration = year-refyear_report


*MORTGAGE DURATION
*This updates for time of refinance
g pduration = purchduration
replace pduration = yearsataddress if yearsataddress < pduration 
replace pduration = refduration if refduration < pduration 
replace pduration = 0 if pduration == -1


*This is the purchase year based on either reported year or years at address
*It is adjusted for refinancing
g origyear = year-pduration


g loanexpect = hsmgfin
replace loanexpect = . if loanexpect < 0
g lduration = loanexpect-year

***************************
*STOCK OF DEBT AT ORIGINATION
***************************

*Updates the stock if there has been a refinance
*Important to base it in reported estimates 
g origdebt = purchdebt_report
replace origdebt = refdebt_report if refdebt_report ~=.


*DV: Household Debt [imputed] ($) [weighted topcode]
g hhdebt = hwdebti  
g lhhdebt = log(hhdebt)

*Mortgage on own home (in wealth years)
*Does this include investor debt??? 
g homevalue = hwhmvai
g homedebt = hwhmdti

*WEIGHT 
g pwt = hhwte

egen id = group(xwaveid)
tsset id year 

g emp = (esbrd==1)

g unemp = (esbrd==2)
replace unemp = . if esbrd < 0

g owner = (hstenr==1)
replace owner = 1 if hstenur==1 & year == 2001

g dinc = hifditp -hifditn
g ldinc = log(dinc)

g age = hgage
g agesq= age*age

g selfemp =  (esempst>1)
replace selfemp = . if esempst==.
g employee = (esempst==1)

g casual = (jbcasab==1)

g hsize = hhpers
g lhsize = log(hsize)


merge 1:1 xwaveid year using "`location'\required_new.dta" , nogen keep(match master)

g buffer1 = schedule-homedebt
replace buffer1 = 0  if buffer1< 0 

*Liquidity 
g cash = hwcaini
g deposits = hwtbani
g equities = hweqini 
g trusts= hwtrusi

*DO WE WANT SUPER OF RETIREES  
g liqasset = cash+deposit+equities +trusts 
replace liqasset = liqasset+buffer1


g mortgagor = (homedebt>0)
replace mortgagor = . if homedebt == . 

*Should try and include redraw here 
g buffer = liqasset/dinc 

********************
*Expected job loss
********************

*PQ: Percent chance of losing job in next 12 months
g ejobloss = jbmploj
replace ejobloss = . if jbmploj > 100
replace ejobloss = . if jbmploj < 0
replace ejobloss = ejobloss/100

  
merge 1:1 xwaveid year using "`location'\uncertainty.dta", nogen keep(match master)
  
*************
*OUTLIERS 
*************
g module = (year ==2002 | year == 2006 | year == 2010 | year == 2014 | year == 2018)
keep if module == 1

*IMPORTANT 
g outlier = 0
replace outlier = 1 if buffer > 10 | buffer < 0 
drop if outlier == 1 

drop if age < 18
drop if age > 80

g risky = (ejobloss > 0.1)
replace risky = . if ejobloss == . 

g highuncertain = (uncertainty > 0.3)
replace high = . if uncertainty == .

g expduration = loanexpect-year
g lhomevalue = log(homevalue)
g lhomedebt = log(homedebt)
  
g hpratio = homevalue/dinc 
g hdebtratio = homedebt/dinc 

g industry = jbmi62
replace industry = . if industry < 0
 

g period = 1 if year == 2002 
replace period = 2 if year == 2006
replace period = 3 if year == 2010
replace period = 4 if year == 2014
replace period = 5 if year == 2018
tsset id period 
 g dbuffer=d.buffer 
 

*FOR RDP 
preserve 
xtile uncertainty_nq = uncertainty [aw = hwt_new], nq(4)
keep if mortgagor ==1 
drop if outlier == 1 
collapse(mean) buffer dbuffer [aw = hwt_new], by(uncertainty_nq)
twoway bar buffer uncertainty_nq
twoway bar dbuffer uncertainty_nq
outsheet using "`location'\buffer_by_volatility.csv", comma replace
restore 


preserve 
keep if emp == 1 
xtile ejobloss_nq = ejobloss if ejobloss > 0 [aw = hwt_new], nq(3)
replace ejobloss_nq = 0 if ejobloss == 0 
keep if mortgagor ==1 
drop if outlier == 1 
collapse(mean) buffer dbuffer [aw = hwt_new], by(ejobloss_nq)
twoway bar buffer ejobloss_nq
twoway bar dbuffer ejobloss_nq
outsheet using "`location'\buffer_by_ejobloss.csv", comma replace
restore 

********************
*REGRESSION ANALYSIS Table 1: The Precautionary Saving Channel
********************
reg buffer ejobloss ldinc hpratio i.age i.pduration i.year if mortgagor == 1 & emp == 1 & outlier == 0 , cl(xwaveid) 
su buffer dinc uncertainty if e(sample)
*xtreg buffer ejobloss ldinc hpratio i.age i.pduration i.year if mortgagor == 1 & emp == 1 & outlier == 0 , cl(xwaveid) fe
*xtreg buffer risky ldinc hpratio age agesq pduration i.year if mortgagor == 1 & emp == 1 & outlier == 0 , cl(xwaveid) fe
reg buffer uncertainty  ldinc hpratio  i.age i.pduration i.year if mortgagor == 1 & emp == 1 & outlier == 0 , cl(xwaveid) 
su buffer dinc uncertainty if e(sample)


